//Listing 15.4. Przetwarzanie listy heterogenicznej  podejcie obiektowe
#include <iostream>
#include <fstream>
using namespace std;

struct Person {
public:
       enum Kind { FACULTY, STUDENT } ;
protected:
       Kind kind;    //FACUULTY lub STUDENT
       char id[10];  //dane wsplne dla obu typw
       char* name;   //dugo zmienna
public:
       Person(const char id[], const char nm[], Kind type)
       { strcpy(Person::id, id) ; // skopiuj identyfikator
         name = new char[strlen(nm)+1]; // przygotuj obszar pamici dla nazwiska
         if (name == 0) { cout << "Brak pamici \n"; exit(0); }
         strcpy(name,nm); // skopiuj nazwisko
         kind = type; } // zapamitaj typ obiektu

    Kind getKind() const 
    { return kind; }  //odczytaj typ osoby (klasa Person)

    ~Person()
    { delete [] name; }  //zwolnij pami na stercie
} ;

struct Faculty : public Person { 
private:
        char* rank;  //jedynie dla wykadowcy
public:
        Faculty(const char id[], const char nm[], const char r[])
          : Person(id,nm,FACULTY) // lista inicjalizujca
        { rank = new char[strlen(r)+1];
          if (rank == 0) { cout << "Brak pamici\n"; exit(0); }
          strcpy(rank, r); }
  void write() const   //wywietl rekord
  { cout << " identyfikator:    " << id << endl;  //wywietl identyfikator oraz nazwisko
    cout << " nazwisko:  " << name << endl;
    cout << " stopie:  " << rank << endl << endl; }  //jedynie dla wykadowcy
      ~Faculty()
      { delete [] rank; }  //zwolnij pami na stercie
} ;

struct Student : public Person { 
private:
        char* major;  // jedynie dla studenta
public:
        Student(const char id[], const char nm[], const char m[])
          : Person(id,nm,STUDENT) // lista inicjalizujca
        { major = new char[strlen(m)+1];
          if (major == 0) { cout << "Brak pamici\n"; exit(0); }
          strcpy(major,m); }
  void write () const  //wywietl rekrod
  { cout << " identyfikator:    " << id << endl;  //wywietl identyfikator oraz nazwisko
    cout << " nazwisko:  " << name << endl;
    cout << " specjalizacja:  " << major << endl << endl; }  //jedynie dla studenta
    ~Student()
    { delete [] major; }  //zwolnij pamic na stercie
} ;

void read (ifstream& f, Person*& person)  //odczytaj jeden rekord
{ char kind[8], id[10], name[80], buf[80];
  f.getline(kind,80);  //rozpoznaj nadchodzcy typ
  f.getline(id,10);  // odczytaj identyfikator
  f.getline(name,80);  //odczytaj nazwisko
  f.getline(buf,80);  // stopie czy specjalizacja
  if (strcmp(kind, "FACULTY") == 0)
  { person = new Faculty(id,name,buf); }  //obiekt reprezentuje wykadowc
  else if (strcmp(kind, "STUDENT") == 0)
  { person = new Student(id,name,buf); }  //obiekt reprezentuje studenta
  else
  { cout << " Dane niepoprawne: nieznany typ obiektu\n"; exit(0); }
}

void write (const Person* p) //wyweitl rekord
{ switch (p->getKind()) {  //pobierz typ obiektu
  case Person::FACULTY:
  ((Faculty*)p)->write(); break;  //wykonaj czynno w sposb adekwatny dla wykadowcy
  case Person::STUDENT:
  ((Student*)p)->write(); break;  //wykonaj czynno w sposb adekwatny dla studenta
} }

int main()
{ cout << endl << endl;
  Person* data [20]; int cnt = 0;  //tablica wskanikw
  ifstream from("univ.dat");  //wejciowy plik danych
  if (!from) { cout << " Bd otwarcia pliku\n"; return 0; }
  while (!from.eof ())
  {read(from, data[cnt]);  //odczytuj do czasu napotkania znaku eof
   cnt++; }
  cout << " Cakowita liczba odczytanych rekordw: " << cnt << endl << endl;
  for (int i=0; i < cnt;  i++)
  { write (data [i]); } // wywietl dane
  for (int j=0; j < cnt;  j++)
  { delete data[j]; } // usu rekord
  return 0 ;
}
